<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;

/**
 * MarketSegment
 *
 * @ORM\Table(name="market_segments")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class MarketSegment
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(name="production_cost", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $productionCost = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="currency_production_cost", type="string", length=10)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $currencyProductionCost = 'PLN';

    /**
     * @var integer
     *
     * @ORM\Column(name="energy_cost", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $energyCost = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="max_production_for_one_place", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $maxProductionForOnePlace = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="max_price", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $maxPrice = 0;

    /**
     * @var string
     *
     * @ORM\Column(name="symbol", type="string", length=30)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    private $symbol ='';

    /**
     * @ORM\OneToMany(targetEntity="\Import\ApiBundle\Entity\PKD", mappedBy="marketSegment")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $codesPkd;

    /**
     * @var text $restrictions
     *
     * @ORM\Column(name="restrictions", type="text")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $restrictions = '';

    /**
     * @ORM\OneToMany(targetEntity="User", mappedBy="marketSegment")
     */
    protected $users;

    /**
     * @ORM\OneToMany(targetEntity="Department", mappedBy="marketSegment")
     */
    protected $departments;

    /**
     * @ORM\OneToMany(targetEntity="DistributionSales", mappedBy="marketSegment")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $distributionSales;

    /**
     * @ORM\OneToMany(targetEntity="OfferReport", mappedBy="marketSegment")
     */
    protected $offerReports;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return MarketSegment
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add users
     *
     * @param \VM\ApiBundle\Entity\User $users
     * @return MarketSegment
     */
    public function addUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users[] = $users;
    
        return $this;
    }

    /**
     * Remove users
     *
     * @param \VM\ApiBundle\Entity\User $users
     */
    public function removeUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users->removeElement($users);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add codesPkd
     *
     * @param \Import\ApiBundle\Entity\PKD $codesPkd
     * @return MarketSegment
     */
    public function addCodesPkd(\Import\ApiBundle\Entity\PKD $codesPkd)
    {
        $this->codesPkd[] = $codesPkd;
    
        return $this;
    }

    /**
     * Remove codesPkd
     *
     * @param \Import\ApiBundle\Entity\PKD $codesPkd
     */
    public function removeCodesPkd(\Import\ApiBundle\Entity\PKD $codesPkd)
    {
        $this->codesPkd->removeElement($codesPkd);
    }

    /**
     * Get codesPkd
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCodesPkd()
    {
        return $this->codesPkd;
    }

    /**
     * Set productionCost
     *
     * @param float $productionCost
     * @return MarketSegment
     */
    public function setProductionCost($productionCost)
    {
        $this->productionCost = $productionCost;
    
        return $this;
    }

    /**
     * Get productionCost
     *
     * @return float 
     */
    public function getProductionCost()
    {
        return $this->productionCost;
    }

    /**
     * Set maxProductionForOnePlace
     *
     * @param integer $maxProductionForOnePlace
     * @return MarketSegment
     */
    public function setMaxProductionForOnePlace($maxProductionForOnePlace)
    {
        $this->maxProductionForOnePlace = $maxProductionForOnePlace;
    
        return $this;
    }

    /**
     * Get maxProductionForOnePlace
     *
     * @return integer 
     */
    public function getMaxProductionForOnePlace()
    {
        return $this->maxProductionForOnePlace;
    }

    /**
     * Add departments
     *
     * @param \VM\ApiBundle\Entity\Department $departments
     * @return MarketSegment
     */
    public function addDepartment(\VM\ApiBundle\Entity\Department $departments)
    {
        $this->departments[] = $departments;
    
        return $this;
    }

    /**
     * Remove departments
     *
     * @param \VM\ApiBundle\Entity\Department $departments
     */
    public function removeDepartment(\VM\ApiBundle\Entity\Department $departments)
    {
        $this->departments->removeElement($departments);
    }

    /**
     * Get departments
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDepartments()
    {
        return $this->departments;
    }

    /**
     * Add offerReports
     *
     * @param \VM\ApiBundle\Entity\OfferReport $offerReports
     * @return MarketSegment
     */
    public function addOfferReport(\VM\ApiBundle\Entity\OfferReport $offerReports)
    {
        $this->offerReports[] = $offerReports;
    
        return $this;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return MarketSegment
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Remove offerReports
     *
     * @param \VM\ApiBundle\Entity\OfferReport $offerReports
     */
    public function removeOfferReport(\VM\ApiBundle\Entity\OfferReport $offerReports)
    {
        $this->offerReports->removeElement($offerReports);
    }

    /**
     * Get offerReports
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOfferReports()
    {
        return $this->offerReports;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set energyCost
     *
     * @param float $energyCost
     * @return MarketSegment
     */
    public function setEnergyCost($energyCost)
    {
        $this->energyCost = $energyCost;
    
        return $this;
    }

    /**
     * Get energyCost
     *
     * @return float 
     */
    public function getEnergyCost()
    {
        return $this->energyCost;
    }

    /**
     * Set restrictions
     *
     * @param string $restrictions
     * @return MarketSegment
     */
    public function setRestrictions($restrictions)
    {
        $this->restrictions = $restrictions;
    
        return $this;
    }

    /**
     * Get restrictions
     *
     * @return string 
     */
    public function getRestrictions()
    {
        return $this->restrictions;
    }

    /**
     * Set currencyProductionCost
     *
     * @param string $currencyProductionCost
     * @return MarketSegment
     */
    public function setCurrencyProductionCost($currencyProductionCost)
    {
        $this->currencyProductionCost = $currencyProductionCost;
    
        return $this;
    }

    /**
     * Get currencyProductionCost
     *
     * @return string 
     */
    public function getCurrencyProductionCost()
    {
        return $this->currencyProductionCost;
    }

    /**
     * Add distributionSales
     *
     * @param \VM\ApiBundle\Entity\DistributionSales $distributionSales
     * @return MarketSegment
     */
    public function addDistributionSale(\VM\ApiBundle\Entity\DistributionSales $distributionSales)
    {
        $this->distributionSales[] = $distributionSales;
    
        return $this;
    }

    /**
     * Remove distributionSales
     *
     * @param \VM\ApiBundle\Entity\DistributionSales $distributionSales
     */
    public function removeDistributionSale(\VM\ApiBundle\Entity\DistributionSales $distributionSales)
    {
        $this->distributionSales->removeElement($distributionSales);
    }

    /**
     * Get distributionSales
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDistributionSales()
    {
        return $this->distributionSales;
    }

    /**
     * Set maxPrice
     *
     * @param string $maxPrice
     * @return MarketSegment
     */
    public function setMaxPrice($maxPrice)
    {
        $this->maxPrice = $maxPrice;
    
        return $this;
    }

    /**
     * Get maxPrice
     *
     * @return string 
     */
    public function getMaxPrice()
    {
        return $this->maxPrice;
    }
}